#Import "<std>"
#Import "<mojo>"
 
Using std..
Using mojo..
Using gles20..

#import "matrix"

#import "assets/deltafang-hold.3do"
#import "assets/tree.3do"
#import "assets/sphere.3do"
#import "assets/isphere2.3do"
#import "assets/orbit.3do"

#import "assets/spaceship.3do"
#import "assets/asteroid.3do"

#import "assets/base.3do"
#import "assets/grid.3do"
#import "assets/gridcube.3do"
#import "assets/gridFlat.3do"
#import "assets/gridpin.3do"

#import "assets/orbit1.3do"
#import "assets/circle.3do"

#import "assets/orbit2.3do"
#import "assets/slice1.3do"
#import "assets/slice2.3do"
#import "assets/slice3.3do"

#import "assets/scifi.jpg"
#import "assets/uv.jpg"
 
Const Size := New Vec2i( 950,720 )
 
 
Class R3dLoader Extends ResourceManager
	field Vertices:Float[]
	'NOTE anticlockwise winding!!!!!!
	field Elements:int[]
	
	field ElementLength:int
	
	field NormalX:float
	field NormalY:float
	field NormalZ:float


	method New()
	End method
	
	method New( path:string )
		Load( path )
	End method
	
	method Load:bool( path:string )
		_pathname = path
		Local file := Stream.Open( path, "r" )
		If Not file Then
			Print "Cant Load "+path
			Return False
		End If
		
		Local str:string
		
		str = String.FromChar( file.ReadByte() )
		str += String.FromChar( file.ReadByte() )
		str += String.FromChar( file.ReadByte() )
		str += String.FromChar( file.ReadByte() )
'		Print str
		If str <> "RIFF" Then
			file.Close()
			Print "Error: Initial Header RIFF missing"
			return False
		End If
		Local fileLength:int = file.ReadInt()

		Local Error:Int = False
		Local k:Int
		Local CurrentModel:Int = - 1
		
		Local ModelCount:Int = 0
		Local modelref:int[] = new Int[2000]
		
		Local axisx:Float
		Local axisy:Float
		Local axisz:Float
		
		Local checkGUID:Int = False
		
		Local ID:string
		Local FileLength:Int
		Local chunk:Int = 0
		Local chunksize:Int = 0
		
		FileLength = file.Length
			
		Local Version:Int = - 1
		Local Stored:Int
		Local Objects:Int
				
		Local colorCount:Int = 0
		Local r:float
		Local g:float
		Local b:float
		Local a:float
		Local ColExists:Int
		
		Local SaveColRef:Color[] = New Color[1024]
		Local VertX:float[]
		Local VertY:float[]
		Local VertZ:float[]
		
		Local Faces0:short[]
		Local Faces1:short[]
		Local Faces2:short[]
		Local FaceCol0:short[]
		Local FaceCol1:short[]
		Local FaceCol2:short[]
		Local FaceUVX0:float[]
		Local FaceUVX1:float[]
		Local FaceUVX2:float[]
		Local FaceUVY0:float[]
		Local FaceUVY1:float[]
		Local FaceUVY2:float[]
		
		Local VertexRef:short[]
		Local VertexVert:short[]
		Local VertexCol:short[]
		Local VertexUV:short[]
		Local VertexCount:int = -1
				
		Local name:String
				
		Local x:Float
		Local y:Float
		Local z:Float
				
		Local col1:Int
		Local col2:Int
		Local col3:Int
		Local uvx1:Float
		Local uvy1:Float
		Local uvx2:Float
		Local uvy2:Float
		Local uvx3:Float
		Local uvy3:Float
				
		'now cycle through the data and process
			
		'load the header
		
		While Not(Error) And file.Position < FileLength
			If Not file.Eof Then
				ID = String.FromChar( file.ReadByte() )
				If Not file.Eof Then
					ID += String.FromChar( file.ReadByte() )
					If Not file.Eof Then
						ID += String.FromChar( file.ReadByte() )
						If Not file.Eof Then
							ID += String.FromChar( file.ReadByte() )
						Else
							Error = True
						End If
					Else
						Error = True
					End If
				Else
					Error = True
				End If
			Else
				Error = True
			End If

			If Error Then
				file.Close()
				Print "Error with Header"
				Exit
			End If

			chunksize = 0
			If Not file.Eof Then
				'get the chunksize
				chunksize = file.ReadInt()
			Else
				file.Close()
				Error = True
				Exit
			End If

'			Print "chunk id=" + ID+" size="+chunksize+" chunk="+chunk

			Select ID
				Case "RAMO"
					If chunk > 0 Then Exit
					
				Case "form"	
'					If chunk < 1 Then Exit
							
					Version = file.ReadShort()
					Stored = file.ReadShort()
					Objects = file.ReadShort()
							
'					Print "~nform Version=" + Version
					Select Stored
						Case 1
							Print "contents = "+Objects+" type=model"
						Case 2
							Print "contents = "+Objects+" type=group"
						Case 3
							Print "contents = " + Objects+" type=multiple"
					End Select		
							
					file.ReadShort()
	
					file.ReadShort()
					file.ReadShort()
					file.ReadShort()
					file.ReadShort()
#jump colors
				Case "cols"	
'					Print chunk+" "+Version
					If Version < 1 Then Exit
					colorCount = file.ReadInt()
'					Print "Colors = " + colorCount
					For k = 0 until colorCount
						r = float( file.ReadUByte() )/255
						g = float( file.ReadUByte() )/255
						b = float( file.ReadUByte() )/255
						a = float( file.ReadUByte() )/255
						
						SaveColRef[k] = New Color( r, g, b, a )

'						ColExists = AddColori(r, g, b, a)
'						SaveColRef[k] = ColExists
'							SaveColRef[ColExists] = k
						
'						Print "color=" + k + "  r=" + SaveColRef[k].r + " g=" + SaveColRef[k].g + " b=" + SaveColRef[k].b + " a=" + a
'								Print "ref="+colexists+" col="+SaveColRef[k]
					Next	

				Case "name"
'					Print"name chunk="+chunk+" version="+version
					If Version < 1 Then Exit
					
					local str:string = ""
					For k = 1 To chunksize
						str += String.FromChar( file.ReadByte() )
					Next
					name = str
'					Print "name="+name
'					If Not(ignoreLoad) Then
'						ModelBegin(ModelPtr - 1, name, OBJECT_MODEL)
'						Models[ModelPtr].Filename = StripDir(filename)
'					End If
				
				Case "guid"
					If Version < 1 Then Exit

					local str:string = ""
					For k = 1 To chunksize
						str += String.FromChar( file.ReadByte() )
					Next
					name = str
'					Print "guid name="+name
#jump material									
				Case "mat7"	
					If Version < 1 Then Exit

					Local nimage1x:Int
					Local nimage1y:Int
					Local nimage1width:Int
					Local nimage1height:Int
					Local nimage2x:Int
					Local nimage2y:Int
					Local nimage2width:Int
					Local nimage2height:Int

					Local nAlphaOn:Int

					Local nisLight:Int
					Local nisFauxLight:Int
					Local nisGlass:Int
					Local nis2Sided:Int
					Local ncastShadow:Int
					Local nReflect:Int
					Local nShine:Int
					Local fAlpha:Int
					Local nMaterial:Int
					Local nData1:Int
					Local nData2:Int
					Local nData3:Int
					Local nData4:Int
					Local nSmooth:Int
					Local nInvert:Int
					Local nRaise:Int
					Local nSAlpha:Int
					Local nSSS:Int
					Local nSSScatter:Int
					Local nSSBounce:Int
					Local nBump:Int
					Local nFade:Int

					Local nRed2:Int
					Local nGreen2:Int
					Local nBlue2:Int

					nimage1x = file.ReadInt()
					nimage1y = file.ReadInt()
					nimage1width = file.ReadInt()
					nimage1height = file.ReadInt()
					nimage2x = file.ReadInt()
					nimage2y = file.ReadInt()

					nimage2width = file.ReadInt()
					nimage2height = file.ReadInt()
					
'					Print nimage1x+" "+nimage1y+" "+nimage1width+" "+nimage1height+" "+nimage2x+" "+nimage2y+" "+nimage2width+" "+nimage2height

					
					nAlphaOn = file.ReadInt()

					nisLight = file.ReadInt()
					nisFauxLight = file.ReadInt()
					nisGlass = file.ReadInt()
					nis2Sided = file.ReadInt()
					ncastShadow = file.ReadInt()
					nReflect = file.ReadInt()
					nShine = file.ReadInt()

					fAlpha = file.ReadFloat()
					nMaterial = file.ReadInt()
					nData1 = file.ReadInt()
					nData2 = file.ReadInt()
					nData3 = file.ReadInt()
					nData4 = file.ReadInt()
					nSmooth = file.ReadInt()
					nInvert = file.ReadInt()
					nRaise = file.ReadInt()
					nSAlpha = file.ReadInt()
					nSSS = file.ReadInt()
					nSSScatter = file.ReadInt()
					nSSBounce = file.ReadInt()
					nBump = file.ReadInt()
					nFade = file.ReadInt()

					nRed2 = file.ReadInt()
					nGreen2 = file.ReadInt()
					nBlue2 = file.ReadInt()
#rem
					If Not(ignoreLoad) And models[modelptr] Then
						Models[ModelPtr].image1x = nimage1x
						Models[ModelPtr].image1y = nimage1y
						Models[ModelPtr].image1width = nimage1width
						Models[ModelPtr].image1height = nimage1height
						Models[ModelPtr].image2x = nimage2x
						Models[ModelPtr].image2y = nimage2y

						Models[ModelPtr].image2width = nimage2width
						Models[ModelPtr].image2height = nimage2height
						Models[ModelPtr].AlphaOn = nAlphaOn

						Models[ModelPtr].isLight = nisLight
						Models[ModelPtr].isFauxLight = nisFauxLight
						Models[ModelPtr].isGlass = nisGlass
						Models[ModelPtr].is2Sided = nis2Sided
						Models[ModelPtr].castShadow = ncastShadow
						Models[ModelPtr].Reflect = nReflect
						Models[ModelPtr].Shine = nShine

						Models[ModelPtr].Alpha = fAlpha
						Models[ModelPtr].Material = nMaterial
						Models[ModelPtr].Data1 = nData1
						Models[ModelPtr].Data2 = nData2
						Models[ModelPtr].Data3 = nData3
						Models[ModelPtr].Data4 = nData4
						Models[ModelPtr].Smooth = nSmooth
						Models[ModelPtr].Invert = nInvert
						Models[ModelPtr].Raise = nRaise
						Models[ModelPtr].SSS = nSSS
						Models[ModelPtr].SSScatter = nSSScatter
						Models[ModelPtr].SSBounce = nSSBounce
						Models[ModelPtr].Bump = nBump
						Models[ModelPtr].Fade = nFade

						Models[ModelPtr].Red2 = nRed2
						Models[ModelPtr].Green2 = nGreen2
						Models[ModelPtr].Blue2 = nBlue2
					End If
#end					

				Case "axis"
					If Version < 1 Then Exit

					axisx = file.ReadFloat()
					axisy = file.ReadFloat()
					axisz = file.ReadFloat()
#jump vertexes
				Case "vrt2"
					If Version < 1 Then Exit

					Local vertexCount:int = chunksize / 16
'					Print "vertexes = "+ vertexCount
					Local bend:Float
					
					VertX = New float[vertexCount]
					VertY = New float[vertexCount]
					VertZ = New float[vertexCount]

'					If Not(ignoreLoad) Then
'						VertexBegin()
						For k = 0 until vertexCount
							x = file.ReadFloat()
							y = file.ReadFloat()
							z = file.ReadFloat()
							bend = file.ReadFloat()
							
							VertX[k] = x
							VertY[k] = y
							VertZ[k] = -z
'								Print "vertex=" + k + " x=" + x + " y=" + y + " z=" + z
						
'							AddVertex(VertexPos, x,y,z)
'							BendVertexes[VertexPos] = bend
						
'							IncVertex()
						Next
'						VertexEnd()
'					Else
'						For k = 0 until (chunksize / 16)
'							x = file.ReadFloat()
'							y = file.ReadFloat()
'							z = file.ReadFloat()
'							bend = file.ReadFloat()
'
'							Vert0[k] = x
'							Vert1[k] = y
'							Vert2[k] = z
'						Next	
'					End If

				Case "bend"
					If Version < 1 Then Exit
					
					x = file.ReadFloat()
					y = file.ReadFloat()
					z = file.ReadFloat()
					
'					If Not(ignoreLoad) Then
'						Models[ModelPtr].bend = x
'						Models[ModelPtr].bendjitter = y
'						Models[ModelPtr].bendjitterspeed = z
'					End If

				Case "lod1"
'							Print"name chunk="+chunk+" version="+version
					If Version < 1 Then Exit

					Local nIn:Int
					nIn = file.ReadInt()
'							Print "LOD in="+nin
'					If Not(ignoreLoad) Then
'						Models[ModelPtr].LOD = nIn
'					End If
#jump faces
				Case "fac2"
					If Version < 1 Then Exit
					Local faceCount:int = chunksize / 48
'					Print "faces = "+ faceCount
					
					Faces0 = New short[faceCount]
					Faces1 = New short[faceCount]
					Faces2 = New short[faceCount]
					FaceCol0 = New short[faceCount]
					FaceCol1 = New short[faceCount]
					FaceCol2 = New short[faceCount]
					FaceUVX0 = New float[faceCount]
					FaceUVX1 = New float[faceCount]
					FaceUVX2 = New float[faceCount]
					FaceUVY0 = New float[faceCount]
					FaceUVY1 = New float[faceCount]
					FaceUVY2 = New float[faceCount]
					
					VertexVert = New short[faceCount * 3]
					VertexCol = New short[faceCount * 3]
					Local l:int

					'NOTE anticlockwise winding!!!!!!
					Elements = New int[faceCount * 3]

'					If Not(ignoreLoad) Then
'						FaceBegin()
						For k = 0 until faceCount
							Faces0[k] = file.ReadInt()
							Faces1[k] = file.ReadInt()
							Faces2[k] = file.ReadInt()
							
							col1 = file.ReadInt()
							col2 = file.ReadInt()
							col3 = file.ReadInt()
							
							If col1 = -1 Then col1 = 1
							If col2 = -1 Then col2 = 1
							If col3 = -1 Then col3 = 1

							If col1 > colorCount Then col1 = colorCount
							If col2 > colorCount Then col2 = colorCount
							If col3 > colorCount Then col3 = colorCount
							
							FaceCol0[k] = col1
							FaceCol1[k] = col2
							FaceCol2[k] = col3
							
'									Print "Colcount="+colorcount+"  "+col1+" "+col2+" "+col3

							uvx1 = file.ReadFloat()
							uvy1 = file.ReadFloat()

							uvx2 = file.ReadFloat()
							uvy2 = file.ReadFloat()

							uvx3 = file.ReadFloat()
							uvy3 = file.ReadFloat()
							
							FaceUVX0[k] = uvx1
							FaceUVY0[k] = uvy1
							FaceUVX1[k] = uvx2
							FaceUVY1[k] = uvy2
							FaceUVX2[k] = uvx3
							FaceUVY2[k] = uvy3
							
'							Print " face "+k+"  col "+col1+"  uv1 "+uvx1+", "+uvy1+"  uv2 "+uvx2+", "+uvy2+"  uv3 "+uvx3+", "+uvy3

'							Print " face "+k+"  v0 "+Faces0[k]+"."+FaceCol0[k]+"  v1 "+Faces1[k]+"."+FaceCol1[k]+"  v2 "+Faces2[k]+"."+FaceCol2[k]
							
							Local got:int = -1
							If VertexCount = -1 Then
								got = 0
								VertexVert[0] = Faces0[0]
								VertexCol[0] = FaceCol0[0]
								VertexCount = 1
							Else
								l = 0
								Repeat
									If Faces0[k] = VertexVert[l] And FaceCol0[k] = VertexCol[l] Then got = l
									l += 1
								Until l >= VertexCount or got > -1
								If got = -1 Then
									got = VertexCount
									VertexVert[VertexCount] = Faces0[k]
									VertexCol[VertexCount] = FaceCol0[k]
									VertexCount += 1
								End If
							End If
							Faces0[k] = got

							got = -1
							l = 0
							Repeat
								If Faces1[k] = VertexVert[l] And FaceCol1[k] = VertexCol[l] Then got = l
								l += 1
							Until l >= VertexCount or got > -1
							If got = -1 Then
								got = VertexCount
								VertexVert[VertexCount] = Faces1[k]
								VertexCol[VertexCount] = FaceCol1[k]
								VertexCount += 1
							End If
							Faces1[k] = got

							got = -1
							l = 0
							Repeat
								If Faces2[k] = VertexVert[l] And FaceCol2[k] = VertexCol[l] Then got = l
								l += 1
							Until l >= VertexCount or got > -1
							If got = -1 Then
								got = VertexCount
								VertexVert[VertexCount] = Faces2[k]
								VertexCol[VertexCount] = FaceCol2[k]
								VertexCount += 1
							End If
							Faces2[k] = got
							
'							Print "   "+Faces0[k]+" "+Faces1[k]+" "+Faces2[k]
							
'							Elements[k * 3] = Faces0[k]
'							Elements[k * 3 + 1] = Faces1[k]
'							Elements[k * 3 + 2] = Faces2[k]
							Elements[k * 3] = k * 3
							Elements[k * 3 + 1] = k * 3 + 1
							Elements[k * 3 + 2] = k * 3 + 2
							
							
'								Print "face=" + k + " v1=" + v1 + " v2=" + v2 + " v3=" + v3 + " col1=" + col1 + " col2=" + col2 + " col3=" + col3
'								Print "face=" + k + " v1=" + v1 + " v2=" + v2 + " v3=" + v3 + "  tx1="+uvx1+" ty1="+uvy1 + "  tx2="+uvx2+" ty2="+uvy2 + "  tx3="+uvx3+" ty3="+uvy3
'							Print " colref col1="+SaveColRef[col1]+" col2="+SaveColRef[col2]+" col3="+SaveColRef[col3]
							
'							AddFaceUV(FacePos, VertexPtr, v1,v2,v3, SaveColRef[col1], SaveColRef[col2], SaveColRef[col3], uvx1, uvy1, uvx2, uvy2, uvx3, uvy3)
'							IncFace()
						Next
#jump construct						
'						Print VertexCount
						Vertices = New Float[ faceCount * 16 * 3 ]

'						For k = 0 Until VertexCount
'							Print "v "+k+" "+VertexVert[k]+" "+VertX[VertexVert[k]]
'						next
'						Print ""
						
						l = 0
						Local v1:int
						Local v2:int
						Local v3:int
						Local c:int
						For k = 0 Until faceCount
'							Print k+"  "+Faces0[k] +" "+Faces1[k] +" "+Faces2[k]
							v1 = VertexVert[ Faces0[k] ]
							v2 = VertexVert[ Faces1[k] ]
							v3 = VertexVert[ Faces2[k] ]
							
							CalculateNormal( VertX[ v1 ], VertY[ v1 ], VertZ[ v1 ], VertX[ v2 ], VertY[ v2 ], VertZ[ v2 ], VertX[ v3 ], VertY[ v3 ], VertZ[ v3 ] )
'							Print k+"  "+NormalX+" "+NormalY+" "+NormalZ
							
							c = VertexCol[ Faces0[k] ]

							Vertices[l] = SaveColRef[ c ].r
							Vertices[l+1] = SaveColRef[ c ].g
							Vertices[l+2] = SaveColRef[ c ].b
							Vertices[l+3] = SaveColRef[ c ].a
							Vertices[l+4] = VertX[ v1 ]
							Vertices[l+5] = VertY[ v1 ]
							Vertices[l+6] = VertZ[ v1 ]
							Vertices[l+7] = 0
							Vertices[l+8] = NormalX
							Vertices[l+9] = NormalY
							Vertices[l+10] = NormalZ
							Vertices[l+11] = 0
							Vertices[l+12] = FaceUVX0[k]
							Vertices[l+13] = FaceUVY0[k]
							l += 16

							c = VertexCol[ Faces1[k] ]

							Vertices[l] = SaveColRef[ c ].r
							Vertices[l+1] = SaveColRef[ c ].g
							Vertices[l+2] = SaveColRef[ c ].b
							Vertices[l+3] = SaveColRef[ c ].a
							Vertices[l+4] = VertX[ v2 ]
							Vertices[l+5] = VertY[ v2 ]
							Vertices[l+6] = VertZ[ v2 ]
							Vertices[l+7] = 0
							Vertices[l+8] = NormalX
							Vertices[l+9] = NormalY
							Vertices[l+10] = NormalZ
							Vertices[l+11] = 0
							Vertices[l+12] = FaceUVX1[k]
							Vertices[l+13] = FaceUVY1[k]
							l += 16

							c = VertexCol[ Faces2[k] ]

							Vertices[l] = SaveColRef[ c ].r
							Vertices[l+1] = SaveColRef[ c ].g
							Vertices[l+2] = SaveColRef[ c ].b
							Vertices[l+3] = SaveColRef[ c ].a
							Vertices[l+4] = VertX[ v3 ]
							Vertices[l+5] = VertY[ v3 ]
							Vertices[l+6] = VertZ[ v3 ]
							Vertices[l+7] = 0
							Vertices[l+8] = NormalX
							Vertices[l+9] = NormalY
							Vertices[l+10] = NormalZ
							Vertices[l+11] = 0
							Vertices[l+12] = FaceUVX2[k]
							Vertices[l+13] = FaceUVY2[k]
							l += 16
						Next

			End Select	


		wend

		file.Close()
		ElementLength = Elements.Length

		Return true
	End method


	method CalculateNormal( v1x:float, v1y:float, v1z:float, v2x:float, v2y:float, v2z:float, v3x:float, v3y:float, v3z:float )
		local lhsx:float = v2x - v1x
		local lhsy:float = v2y - v1y
		local lhsz:float = v2z - v1z
		Local rhsx:float = v3x - v2x
		Local rhsy:float = v3y - v2y
		Local rhsz:float = v3z - v2z

		'cross
		Local vx:float = lhsy * rhsz - lhsz * rhsy
		Local vy:float = lhsz * rhsx - lhsx * rhsz
		Local vz:float = lhsx * rhsy - lhsy * rhsx

		'normalize
		Local length:double = Sqrt(vx * vx + vy * vy + vz * vz)
    
		NormalX = vx / length
		NormalY = vy / length
		NormalZ = vz / length
	End method

private
	field _pathname:string
End Class


class GLShader
	Field shader:GLuint

	field sColor:int
	field sPosition:int
	field sNormal:int
	field sUV:int

	method New()
		' Load Shader
		shader = SimpleShader()
		
		sColor = glGetAttribLocation( shader, "mx2_Color" )
		sPosition = glGetAttribLocation( shader, "mx2_Vertex" )
		sNormal = glGetAttribLocation( shader, "mx2_Normal" )
		sUV = glGetAttribLocation( shader, "mx2_UV" )
	End method


	method New( vertex:string, fragment:string )
		' Load Shader
		shader = LoadShader( vertex, fragment )
		Print shader
		
		sColor = glGetAttribLocation( shader, "mx2_Color" )
		sPosition = glGetAttribLocation( shader, "mx2_Vertex" )
		sNormal = glGetAttribLocation( shader, "mx2_Normal" )
		sUV = glGetAttribLocation( shader, "mx2_UV" )
	End method


	method GetUniform:int( uniformText:string)
		Return glGetUniformLocation( shader, uniformText )
	End method


	method glLoadProgram:GLuint(vertexSource:String, fragmentSource:String)
		Local vs := glCompile( GL_VERTEX_SHADER, vertexSource )
		Local fs := glCompile( GL_FRAGMENT_SHADER, fragmentSource )
		
		Local program := glCreateProgram()
		
		glAttachShader( program, vs )
		glAttachShader( program, fs )
		
		glLink( program )
		
		glDeleteShader( vs )
		glDeleteShader( fs )
		
		Return program
	End method

	 
	method LoadShader:GLuint( vertex:string, fragment:string )
		local program:int = glLoadProgram(vertex, fragment)
		Return program
	End method


	method SimpleShader:GLuint()
		Local vertex:String = "
		uniform float ViewPoint;
		uniform mat4 Matrix;
		uniform vec3 Color;
		uniform vec3 BaseColor;
		uniform vec4 Light;
		uniform vec3 LightColor;
		attribute vec4 mx2_Vertex;
		attribute vec4 mx2_Color;
		attribute vec4 mx2_Normal;
		attribute vec2 mx2_UV;
		attribute float mx2_Data1;
		attribute float mx2_Data2;
		varying vec3 OutColor;
		varying vec3 OutNormal;
		varying vec4 Light1;
		varying vec2 UV;
		void main() {
			UV = mx2_UV;

			vec4 position = Matrix * mx2_Vertex;
			position.y += position.z * ViewPoint;
			gl_Position = position;
			vec4 normal = normalize(Matrix * mx2_Normal);
			OutNormal = normal.xyz;
			
			Light1 = normalize(vec4(position.xyz-Light.xyz, 0.0));
//			Light1 *= 0.4;
	
			OutColor = mix( mx2_Color.rgb, Color, 1.0-mx2_Color.a ) * LightColor;
//			OutColor = Color;
//			OutColor = mx2_Color.rgb * LightColor;
//			OutColor = vec3( UV, 0.0 );
//			OutColor = OutNormal;
//			OutColor = (mx2_Vertex.rgb+0.25)*1.5;

			OutColor *= BaseColor;
		}
	"
	 
		Local fragment:String = "
		uniform sampler2D TextureSampler;
		uniform float LightMix;
		varying vec3 OutColor;
		varying vec3 OutNormal;
		varying vec4 Light1;
		varying vec2 UV;
		void main() {
//			vec3 color = texture2D( TextureSampler, UV ).rgb;
			
			float cosTheta = dot( OutNormal, Light1.xyz );
//			gl_FragColor = vec4(OutColor * cosTheta, 0);

//			gl_FragColor = vec4(OutColor * cosTheta * color , 0);
//			gl_FragColor = vec4(OutColor * color , 0);
//			gl_FragColor = vec4(OutColor , 1);
//			gl_FragColor = vec4( 1., 1., 1., 0.1 );

			gl_FragColor = mix( vec4(OutColor , 1), vec4(OutColor * cosTheta, 0.25), LightMix );
		}
	"
	 
		local program:int = glLoadProgram(vertex, fragment)
		Return program
	End method
	
End Class


class Rameses3dModel
	field r3d:R3dLoader

	Field vbo:GLuint
	Field ebo:GLuint
	Field shader:GLShader
	
	field ElementLength:int

	Field matrixView:Matrix
	Field matrixProjection:Matrix = New Matrix
	Field matrixViewProjection:Matrix

	field color:Vec4f = New Vec4f

	field time:float
	
	Field matrixUniform:Int
	Field lightUniform:Int
	Field lightColorUniform:Int
	Field lightMixUniform:Int
	Field colorUniform:Int
	Field baseColorUniform:Int
	Field timeUniform:Int
	Field viewpointUniform:Int
	
	field light:Vec4f = New Vec4f
	field lightColor:Color = Color.White
	
	method New( path:string, inShader:GLShader )', projMatrix:Matrix )
		r3d = New R3dLoader( path )
		ElementLength = r3d.ElementLength

		shader = inShader
		matrixUniform = shader.GetUniform( "Matrix" )
		viewpointUniform = shader.GetUniform( "ViewPoint" )
		colorUniform = shader.GetUniform( "Color" )
		baseColorUniform = shader.GetUniform( "BaseColor" )
		timeUniform = shader.GetUniform( "mx2_Time" )
		lightUniform = shader.GetUniform( "Light" )
		lightMixUniform = shader.GetUniform( "LightMix" )
		lightColorUniform = shader.GetUniform( "LightColor" )
	End method

	
	method Bind( projMatrix:Matrix )
		matrixProjection = projMatrix
'		matrixViewProjection = New Matrix
 
		' Create vertex buffer	
		glGenBuffers( 1, Varptr vbo )
		glBindBuffer( GL_ARRAY_BUFFER, vbo )
		glBufferData( GL_ARRAY_BUFFER, r3d.Vertices.Length * 4, r3d.Vertices.Data, GL_STATIC_DRAW )
 
		' create element buffer
		glGenBuffers( 1, Varptr ebo)
		glBindBuffer( GL_ELEMENT_ARRAY_BUFFER, ebo )
		glBufferData( GL_ELEMENT_ARRAY_BUFFER, r3d.Elements.Length * 4, r3d.Elements.Data, GL_STATIC_DRAW )

		'push the data into the buffers
		glBindBuffer( GL_ARRAY_BUFFER, vbo )
		glEnableVertexAttribArray( shader.sColor )
		glEnableVertexAttribArray( shader.sPosition )
		glEnableVertexAttribArray( shader.sNormal )
		glEnableVertexAttribArray( shader.sUV )
		glVertexAttribPointer( shader.sColor, 4, GL_FLOAT, False, 64, Cast<Void Ptr>(0) )
		glVertexAttribPointer( shader.sPosition, 3, GL_FLOAT, true, 64, Cast<Void Ptr>(16) )
		glVertexAttribPointer( shader.sNormal, 4, GL_FLOAT, false, 64, Cast<Void Ptr>(32) )
		glVertexAttribPointer( shader.sUV, 2, GL_FLOAT, false, 64, Cast<Void Ptr>(48) )
 
		' bind the element buffer object
		glBindBuffer( GL_ELEMENT_ARRAY_BUFFER, ebo )
	End method


	method Transform( viewPoint:float, x:float, y:float, z:float, lightMix:float, baseColor:Color, scale:float, scaleHeight:float, yrot:float, xrot:float, zrot:float, lx:float, ly:float, lz:float )
		' update the view projection matrix
		matrixView = Matrix.Scale( scale, scale * scaleHeight, scale )
		matrixView *= Matrix.RotateY(yrot) * Matrix.RotateX(xrot) * Matrix.RotateZ(zrot)
'		matrixView = Matrix.RotateY( App.Millisecs * -0.0005 ) * Matrix.RotateX(1)
		matrixView *= Matrix.Translation( x, y, z )
		matrixViewProjection = matrixView * matrixProjection

		' use the shader and update the matrix uniform
		glUseProgram( shader.shader )
		glUniformMatrix4fv( matrixUniform, 1, False, matrixViewProjection.ToArray.Data )

		glUniform1fv( viewpointUniform, 1, varptr viewPoint )
		
		'update the basecolor
		color.x = baseColor.r
		color.y = baseColor.g
		color.z = baseColor.b
		glUniform3fv( baseColorUniform, 1, Varptr color.x )
		'update the additional color
		color.x = 1
		color.y = 0.2
		color.z = 0
'		color = New Vec4f( 1, 0.2, 0, 0 )
		glUniform3fv( colorUniform, 1, Varptr color.x )
		
		'update the time
		time = Millisecs()
		glUniform1fv( timeUniform, 1, Varptr time )
		
		'update the light
		light.x = -lx
		light.y = -ly
		light.z = -lz
		glUniform4fv( lightUniform, 1, Varptr light.x )
		glUniform1fv( lightMixUniform, 1, Varptr lightMix )
'		local lightColor:Vec3f = new Vec3f( 1, 1, 1 )
'		local lightColor:Color = Color.LightGrey
		glUniform3fv( lightColorUniform, 1, Varptr lightColor.r )
	End method


	method DrawModel()
		glDrawElements( GL_TRIANGLES, ElementLength, GL_UNSIGNED_INT, Cast<Int Ptr>(0) )
	End method


	method DrawPoints()
		glDrawElements( GL_POINTS, ElementLength, GL_UNSIGNED_INT, Cast<Int Ptr>(0) )
	End method

	method DrawLines()
		glDrawElements( GL_LINES, ElementLength, GL_UNSIGNED_INT, Cast<Int Ptr>(0) )
	End method
End Class


class Rameses3d
	Field projMatrix:Matrix
	
	field models:Rameses3dModel[] = New Rameses3dModel[25]
	field modelCount:int = 0
	
	field currentModel:int = -1

	field lx:float = -3
	field ly:float = 3
	field lz:float = -5
	
	field viewPoint:Float = 0

	method New( width:int, height:int )
		SetRes( width, height )
	End method

	
	method Load:int( path:string, inShader:GLShader )
		models[modelCount] = New Rameses3dModel( path, inShader )
		modelCount += 1
		Return modelCount -1
	End method
	
	
	method DrawModelHeight( model:int,  x:float, y:float, z:float, lightMix:float, baseColor:Color, scale:float = 1, scaleHeight:float = 1 )
		If model <> currentModel Then
			currentModel = model
			models[model].Bind( projMatrix )
		End If
		
		
		models[model].Transform( viewPoint, x, y, z, lightMix, baseColor, scale, scaleHeight, 1.6, 0, 0, lx, ly, lz )
		models[model].DrawModel()
	End method


	method DrawModel( model:int,  x:float, y:float, z:float, lightMix:float, baseColor:Color, scale:float = 1, yrot:float = 0, xrot:float = 0, zrot:float = 0 )
		If model <> currentModel Then
			currentModel = model
			models[model].Bind( projMatrix )
		End If
		
		
		models[model].Transform( viewPoint, x, y, z, lightMix, baseColor, scale, 1, yrot, xrot, zrot, lx, ly, lz )
		models[model].DrawModel()
	End method
	

	method DrawPoints( model:int,  x:float, y:float, z:float, lightMix:float, baseColor:Color, scale:float = 1, yrot:float = 0, xrot:float = 0, zrot:float = 0 )
		If model <> currentModel Then
			currentModel = model
			models[model].Bind( projMatrix )
		End If
		
		models[model].Transform( viewPoint, x, y, z, lightMix, baseColor, scale, 1, yrot, xrot, zrot, lx, ly, lz )
		models[model].DrawPoints()
	End method

	
	method DrawLines( model:int,  x:float, y:float, z:float, lightMix:float, baseColor:Color, scale:float = 1, yrot:float = 0, xrot:float = 0, zrot:float = 0 )
		If model <> currentModel Then
			currentModel = model
			models[model].Bind( projMatrix )
		End If
		
		models[model].Transform( viewPoint, x, y, z, lightMix, baseColor, scale, 1, yrot, xrot, zrot, lx, ly, lz )
		models[model].DrawLines()
	End method


	method SetRes( width:float, height:float )
'		Print "setres "+width+" "+height
'		glViewport( 0, 0, width, height )
		projMatrix = Matrix.Perspective(Pi / 4.0, 1.3, 0.5, 1000)
	End method
End Class


Class MyWindow Extends GLWindow
	field myShader:GLShader
	field myShader2:GLShader

	field my3d:Rameses3d
	
	field r3d_Ship:int
	field r3d_Asteroid:int

	field r3d_Planet:int
	field r3d_Orbit:int
	field r3d_Galaxy:int

	field r3d_Base:int
	field r3d_Grid:int
	field r3d_GridCube:int
	field r3d_GridFlat:int
	field r3d_GridPin:int
	
	field r3d_Orbit1:int
	field r3d_Circle:int

	field r3d_Orbit2:int
	field r3d_Slice1:int
	field r3d_Slice2:int
	field r3d_Slice3:int
	
	field tex:Texture

	field ox:float = 0
	field oy:float = -1
	field oz:float = -5
	field objectRotate:float = 0
	
	field sc:float = 1
	
	Method New()
		Super.New( "My Window", Size.X, Size.Y, WindowFlags.Resizable )
	    
		'this is a timer. it will 'tick' 60 times a second. calling OnUpdate
		_timer = New Timer( 60, OnUpdate )

		'if you want a constant canvas size use this
'		Layout = "letterbox"
		'or If you want the canvas to always fill the window use this
		Layout = "fill"

		InitShaders()

		
		'next initalize Rameses
		my3d = New Rameses3d( Width, Height )
		
		r3d_Ship = my3d.Load( "asset::spaceship.3do", myShader )
		r3d_Asteroid = my3d.Load( "asset::asteroid.3do", myShader )

		r3d_Planet = my3d.Load( "asset::sphere.3do", myShader )
'		r3d_Ship = my3d.Load( "asset::tree.3do", myShader )
'		r3d_Ship = my3d.Load( "asset::uvtest.3do", myShader )
		r3d_Orbit = my3d.Load( "asset::orbit.3do", myShader )
		r3d_Galaxy = my3d.Load( "asset::isphere2.3do", myShader2 )

		r3d_Base = my3d.Load( "asset::base.3do", myShader )
		r3d_Grid = my3d.Load( "asset::grid.3do", myShader )
		r3d_GridCube = my3d.Load( "asset::gridcube.3do", myShader )
		r3d_GridFlat = my3d.Load( "asset::gridflat.3do", myShader )
		r3d_GridPin = my3d.Load( "asset::gridpin.3do", myShader )

		r3d_Orbit1 = my3d.Load( "asset::orbit1.3do", myShader )
		r3d_Circle = my3d.Load( "asset::circle.3do", myShader )

		r3d_Orbit2 = my3d.Load( "asset::orbit2.3do", myShader )
		r3d_Slice1 = my3d.Load( "asset::slice1.3do", myShader )
		r3d_Slice2 = my3d.Load( "asset::slice2.3do", myShader )
		r3d_Slice3 = my3d.Load( "asset::slice3.3do", myShader )
		
'		tex = Texture.Load( "asset::uv.jpg", TextureFlags.Dynamic )
		
'		glClearColor(0.1, 0.1, 0.5, 1.0)
		glClearColor(0, 0, 0, 1.0)

		glEnable(GL_CULL_FACE)
		glEnable(GL_DEPTH_TEST)
	End
	
	method InitShaders()
		'first get the shader
		myShader = New GLShader()

		Local vertex:String = "
		uniform mat4 Matrix;
		uniform vec3 Color;
		uniform vec4 Light;
		uniform vec3 LightColor;
		uniform float mx2_Time;
		attribute vec4 mx2_Vertex;
		attribute vec4 mx2_Color;
		attribute vec4 mx2_Normal;
		attribute vec2 mx2_UV;
		attribute float mx2_Data1;
		attribute float mx2_Data2;
		varying vec3 OutColor;
		varying vec3 OutNormal;
		varying vec4 Light1;
		varying vec2 UV;
		varying float Time;
		void main() {
			UV = mx2_UV;
			Time = mx2_Time;

			vec4 position = Matrix * mx2_Vertex;
			gl_Position = position;
			vec4 normal = Matrix * mx2_Normal;
			OutNormal = normal.xyz;
			
			Light1 = normalize(vec4(position.xyz-Light.xyz, 0.0));
			Light1 *= 0.4;
	
			OutColor = mix( mx2_Color.rgb, Color, 1.0-mx2_Color.a ) * LightColor;
//			OutColor = Color;
//			OutColor = mx2_Color.rgb * LightColor;
//			OutColor = vec3( UV, 0.0 );
//			OutColor = OutNormal;
//			OutColor = (mx2_Vertex.rgb+0.25)*1.5;
		}
	"
	 
		Local fragment:String = "
		uniform sampler2D TextureSampler;
		varying vec3 OutColor;
		varying vec3 OutNormal;
		varying vec4 Light1;
		varying vec2 UV;
		varying float Time;

		float field(in vec3 p,float s,  int idx) {
			float strength = 7. + .03 * log(1.e-6 + fract(sin(Time) * 4373.11));
			float accum = s/4.;
			float prev = 0.;
			float tw = 0.;
			for (int i = 0; i < 26; ++i) {
				float mag = dot(p, p);
				p = abs(p) / mag + vec3(-.5, -.4, -1.5);
				float w = exp(-float(i) / 7.);
				accum += w * exp(-strength * pow(abs(mag - prev), 2.2));
				tw += w;
				prev = mag;
			} 
			return max(0., 5. * accum / tw - .7);
		}
		
		vec3 nrand3( vec2 co ){
			vec3 a = fract( cos( co.x*8.3e-3 + co.y )*vec3(1.3e5, 4.7e5, 2.9e5) );
			vec3 b = fract( sin( co.x*0.3e-3 + co.y )*vec3(8.1e5, 1.0e5, 0.1e5) );
			vec3 c = mix(a, b, 0.5);
			return c;
		}
		
		
		float snoise(vec3 uv, float res){
			const vec3 s = vec3(1e0, 1e2, 1e3);
		
			uv *= res;
		
			vec3 uv0 = floor(mod(uv, res))*s;
			vec3 uv1 = floor(mod(uv+vec3(1.), res))*s;
		
			vec3 f = fract(uv); f = f*f*(3.0-2.0*f);
		
			vec4 v = vec4(uv0.x+uv0.y+uv0.z, uv1.x+uv0.y+uv0.z, uv0.x+uv1.y+uv0.z, uv1.x+uv1.y+uv0.z);
		
			vec4 r = fract(sin(v*1e-1)*1e3);
			float r0 = mix(mix(r.x, r.y, f.x), mix(r.z, r.w, f.x), f.y);
		
			r = fract(sin((v + uv1.z - uv0.z)*1e-1)*1e3);
			float r1 = mix(mix(r.x, r.y, f.x), mix(r.z, r.w, f.x), f.y);
		
			return mix(r0, r1, f.z)*2.-1.;
		}


		void main(){
			vec2 uv = UV;
			
			vec2 uvs = vec2(cos(uv.x), uv.y);
			
			vec3 p = vec3(uvs / 4., 0) + vec3(1., -1.3, 0.);
			p += vec3(sin(16.), sin(12.),  sin(128.));
		
			float freqs[4];
			freqs[0] = 0.05;
			freqs[1] = 0.3;
			freqs[2] = 0.3;
			freqs[3] = 0.7;
			
			float width = 4096.0;
		
			float t = 1.0-cos(field(p, freqs[3], 26));
			float v = (1. - exp((abs(uv.x) - 1.) * 6.)) * (1. - exp((abs(uv.y) - 1.) * 6.));
		
			vec2 pp = uv;
			pp.x = pp.x*3.0 - 2.0;
			pp.y = pp.y*4.0 - 2.0;
			pp.y = -pp.y ;
	
			p.x *= 0.5;
			  	
			float color = 3.0 - (6.*length(pp));
	
			vec3 coord = vec3(atan(pp.x,pp.y)/6.2832, length(pp)*0.4, .5);
	
			for(int i = 1; i <= 7; i++){
				float power = pow(2.0, float(i));
//				color += (1.5 / power) * snoise(coord + vec3(0.,-0.*.05, 0.*.01), power*16.);
				color += (1.5 / power) * snoise(coord + vec3(0.,-Time*.000005, Time*.000005), power*16.);
			}
	
			vec4 c2 = vec4( color*0.1, pow(max(color,0.),2.)*0.01, pow(max(color,0.),3.)*0.05 , 1.0);//*0.2;



			
			vec4 starcolor = vec4(0.0, 0.0, 0.0, 0.0);

			//Let's add some stars
			vec2 seed = p.xy * 12.0;
			seed = floor(seed * 2.0 * width);
			vec3 rnd = nrand3( seed );
			starcolor += vec4(pow(rnd.y, 50.0));
		
			//Second Layer
			vec2 seed2 = p.xy * 4.0;
			seed2 = floor(seed2 * width);
			vec3 rnd2 = nrand3( seed2 );
			starcolor += vec4(pow(rnd2.y,85.0)) * 2.0;
			
			vec4 bgColor = vec4(1.5*freqs[2] * t * t* t , 1.2*freqs[1] * t * t, sin(freqs[3]*t), 1.0);
			
			vec4 outColor = bgColor + c2 + starcolor;

//			vec3 coloruv = texture2D( TextureSampler, UV ).rgb;
//			vec4 coloruv2 = vec4( coloruv, 1.0) * 0.5;

			gl_FragColor = outColor;// + coloruv2;
		}
	"
		myShader2 = New GLShader( vertex, fragment )
	End method

	
	Method OnUpdate()
'		_gameTime = Millisecs()
		
'		RequestRender()
	End Method


	Method OnRender(canvas:mojo.graphics.Canvas) Override
		App.RequestRender()
		Super.OnRender(canvas)

		'set up a measure that will recalculate if the window is resized
		If _width <> Width or _height <> Height Then
			my3d.SetRes( Width, Height )
			'The Page Must be laid out
'			Page.OnRecalcLayout( 0, 0, Width, Height )
			

'			local texint:GLuint = tex.GLTexture
'			tex.Bind( 0, TextureFilter.None )

			_width = Width
			_height = Height
		End if


		canvas.DrawText("lx "+my3d.lx, 10, 10)
		canvas.DrawText("ly "+my3d.ly, 10, 30)
		canvas.DrawText("lz "+my3d.lz, 10, 50)

		canvas.DrawText("ox "+ox, 80, 10)
		canvas.DrawText("oy "+oy, 80, 30)
		canvas.DrawText("oz "+oz, 80, 50)
		
'		canvas.Color = Color.White
'		canvas.DrawLine( 0, Height*0.5, Width, Height * 0.5 )
'		canvas.DrawLine( Width*0.5, 0, Width*0.5, Height )
		canvas.DrawText( "FPS="+App.FPS,Width,0,1,0 )
'		canvas.DrawText( "Mojo Rendering+OpenGL rendering!",Width/2,Height/2,.5,.5 )
	End

	
	Method OnKeyEvent( event:KeyEvent ) Override
		'heres the best way to check for shift keys etc
		local shift:bool = event.Modifiers & Modifier.Shift
		
		Select event.Type
			case EventType.KeyDown
			
				Select event.Key
					Case Key.LeftBracket
						sc -= 0.1
					Case Key.RightBracket
						sc += 0.1
					Case Key.Up
						If shift Then
							my3d.lz += 1
						Else
							my3d.ly += 1
						End If
					Case Key.Down
						If shift Then
							my3d.lz -= 1
						Else
							my3d.ly -= 1
						End If
					Case Key.Left
						my3d.lx -= 1
					Case Key.Right
						my3d.lx += 1
				End Select
		End Select
		
	End method


	Method OnRenderGL() Override
'		glClearColor( 0,0,1,1 )
		
'		glClearDepthf( 0 )
		
		glClearStencil( 0 )
		
		glClear( GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT|GL_STENCIL_BUFFER_BIT )


		'Drawing area. You're always drawing to the entire window in GL regardless of Layout.
		'
		'Don't really need this for this example is it only affects glDrawBlah, but nice to know...
		'
		glViewport( 0,0,Frame.Width,Frame.Height )


'		glFlush()
		
		'clear the screen buffers
'		glClear( GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT)
'		glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT )


		
		Local pitch:float = Sin(App.Millisecs*0.001)
		Local rotate:float = App.Millisecs * -0.0005
		Local roll:float = 0

'		my3d.DrawModel( r3d_Ship, ox, oy, oz, Color.Grey, sc*0.1, 1.6, pitch, roll )
'		my3d.DrawLines( r3d_Ship, ox, oy, oz, Color.White, sc*1.01, 1.6, Sin(App.Millisecs*0.0001)  )

		my3d.DrawModel( r3d_Galaxy, 0, 0, -50, 0, Color.White, 200, 0, 2 )

'		my3d.DrawModel( r3d_Planet, my3d.lx, my3d.ly, my3d.lz, 0, Color.White, 0.1 )
'		my3d.DrawPoints( r3d_Planet, my3d.lx, my3d.ly, my3d.lz, Color.White, 1, App.Millisecs * 0.0005 )
'		my3d.DrawLines( r3d_Planet, my3d.lx, my3d.ly, my3d.lz, Color.White, 1, App.Millisecs * 0.0005 )


		Local scale:float = 1.6
		my3d.viewPoint = 1.7
		my3d.DrawModel( r3d_Base, 0, -1.5, -3.7, 0,  Color.Black, sc*scale, 0)
'		my3d.DrawLines( r3d_Grid, 0, -1.5, -3.7, 1,  Color.Cyan*0.5, sc*scale, 0)

		Local sc2:float = scale * 0.1
		Local sc3:float = sc2 * 0.5
		Local sc4:float = sc2 * 1.8
		Local xp:int = 3
		Local yp:int = 3
		my3d.DrawModel( r3d_Ship, sc3+sc2*xp, -1.5+sc4, -3.7+sc2*yp+sc3, 1,  Color.White, sc3, 1.6 )
		my3d.DrawModel( r3d_GridPin, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 1,  Color.Grey, sc*scale, 1.6)

		xp = -2
		yp = -4
		objectRotate += 0.01
		my3d.DrawModel( r3d_Ship, sc3+sc2*xp, -1.5+sc4, -3.7+sc2*yp+sc3, 1,  Color.White, sc3, objectRotate )
		my3d.DrawModel( r3d_GridPin, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 1,  Color.Red*0.5, sc*scale, objectRotate )


			xp = -3
			yp = -2
			my3d.DrawModel( r3d_Asteroid, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.DarkGrey, sc*scale*0.4, objectRotate)
			my3d.DrawModel( r3d_GridPin, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 1,  Color.Red*0.5, sc*scale*0.5 )


		my3d.viewPoint = 1.7
		my3d.DrawLines( r3d_Grid, 0, -1.5, -3.7, 1,  Color.Cyan*0.5, sc*scale, 0)

		'draw bottom ship
		my3d.DrawLines( r3d_Ship, -0.45, -0.35, -1, 0,  Color.Pine, sc*0.03, rotate, pitch, roll )
		my3d.DrawLines( r3d_Orbit, -0.45, -0.365, -1, 0,  Color.Pine*0.4, sc*0.08, rotate-0.9, pitch, roll )

		'draw current system
'		my3d.DrawPoints( r3d_Planet, 0.45, -0.365, -1, Color.Pine, 0.03 )
		
'		my3d.DrawLines( r3d_Orbit1, 0.45, -0.365, -1, Color.Pine*0.3, 0.1 )
'		my3d.DrawPoints( r3d_Planet, 0.45+0.04, -0.365, -1, Color.Pine, 0.02 )

'		my3d.DrawLines( r3d_Orbit1, 0.45, -0.365, -1, Color.Pine*0.3, 0.2 )
'		my3d.DrawPoints( r3d_Planet, 0.45+0.08, -0.365, -1, Color.Pine, 0.01 )

'		my3d.DrawLines( r3d_Orbit1, 0.45, -0.365, -1, Color.Pine*0.3, 0.24 )

'		my3d.DrawLines( r3d_Orbit1, 0.45, -0.365, -1, Color.Pine*0.3, 0.34 )
'		my3d.DrawPoints( r3d_Planet, 0.45-0.095, -0.365, -1, Color.Pine, 0.01 )

		'draw main viewer
		my3d.viewPoint = 0
		my3d.DrawLines( r3d_Orbit2, 0, -0.3, -1, 0,  Color.Pine*0.5, sc*1, 0 )

'		glEnable(GL_BLEND)
'		glBlendFunc(GL_SRC_ALPHA, GL_ONE)
		
'			my3d.DrawModel( r3d_Circle, 0, -0.3, -1, Color.Pine*0.1, sc, 0 )
'		
'			my3d.DrawModel( r3d_Slice1, 0, -0.3, -1, Color.Orange*0.4, sc*1.1, 0 )
'			my3d.DrawModel( r3d_Slice2, 0, -0.3, -1, Color.Brown*0.3, sc*0.9, 0 )
'			my3d.DrawModel( r3d_Slice3, 0, -0.3, -1, Color.Brown*0.2, sc*0.8, 0 )
'		
'		glDisable(GL_BLEND)

		'draw transparent things
		my3d.viewPoint = 1.7
		glEnable(GL_BLEND)
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
			xp = 2
			yp = 2
			my3d.DrawModelHeight( r3d_GridCube, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Grey, sc*scale, 0.2)
			my3d.DrawModelHeight( r3d_GridFlat, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Aqua, sc*scale, 0.2)
			xp = 3
			yp = 2
			my3d.DrawModelHeight( r3d_GridCube, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Grey, sc*scale, 0.4)
			my3d.DrawModelHeight( r3d_GridFlat, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Aqua, sc*scale, 0.4)
'			xp = -3
'			yp = -2
'			my3d.DrawModelHeight( r3d_GridCube, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Grey, sc*scale, 0.4)
'			my3d.DrawModelHeight( r3d_GridFlat, sc3+sc2*xp, -1.5, -3.7+sc2*yp+sc3, 0.6,  Color.Red, sc*scale, 0.4)
		glDisable(GL_BLEND)
	End

	
private	
	'the timer ticks 60 times a second and handles the screen update
	Field _timer:Timer

	'global window size to track when window has changed
	field _width:int = 0
	field _height:int = 0
End
 
 
Function Main()
	Local cfg := New StringMap<String>
	
	cfg["GL_depth_buffer_enabled"] = 1
	cfg["GL_stencil_buffer_enabled"] = 1

	New AppInstance( cfg )

	New MyWindow
	App.Run()
End